<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Share Icons 
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_filter('sao_element_item', 'sao_element_item_share_icons');
function sao_element_item_share_icons( $element ) {
 	
 	$element[]=array(
 		'name'			=> 	esc_html__('Share Icons','reza'),
 		'id'			=> 'share_icons',
		'group'			=> esc_html__('rabonews','reza'),		
		'img'			=>  REZA_DIR.'/admin/assets/images/element-share.jpg',
  	); 
   
	return $element;
}  
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Share Icons Options
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_filter('sao_element_options_share_icons', 'reza_share_icons_options');
function reza_share_icons_options( $option ) {
  

	$option[]= array( 
		"name"			=> __('URL Share','reza'),
 		"id"			=> "share_url",
 		"type"			=> "text",
 		"default"		=> "http://google.com",
		 
 	);
	
	$option[]= array( 
		"name"			=> __('Share on Facebook','reza'),
 		"id"			=> "facebook",
  		"type"			=> "checkbox",
 		"default"		=> 1,
 	);
	
	$option[]= array( 
		"name"			=> __('Share on Twitter','reza'),
 		"id"			=> "twitter",
  		"type"			=> "checkbox",
 		"default"		=> 1,
 	);
	
	$option[]= array( 
		"name"			=> __('Share on Google+','reza'),
 		"id"			=> "googleplus",
  		"type"			=> "checkbox",
 		"default"		=> 1,
 	);
	
	$option[]= array( 
		"name"			=> __('Share on Tumblr','reza'),
 		"id"			=> "tumblr",
 		"default"		=> 1,
  		"type"			=> "checkbox",
 	);
	
	$option[]= array( 
		"name"			=> __('Share on Linkedin','reza'),
 		"id"			=> "linkedin",
 		"default"		=> 1,
  		"type"			=> "checkbox",
 	);				


	
	$option[]= array( 
		"name"			=> __('Share by Reddit','reza'),
 		"id"			=> "reddit",
 		"default"		=> 1,
		
  		"type"			=> "checkbox",
 	);				
	
	$option[]= array( 
		"name"			=> __('Share by Telegram','reza'),
 		"id"			=> "telegram",
 		"default"		=> 1,
  		"type"			=> "checkbox",
 	);				 	 
		   
	
	$option[]= array( 
		"name"			=> __('Share by Mail','reza'),
 		"id"			=> "mail",
  		"type"			=> "checkbox",
 		"default"		=> 1,
 	);				
	$option[]= array( 
		"name"			=> __('Share by Whatsapp','reza'),
 		"id"			=> "whatsapp",
  		"type"			=> "checkbox",
 		"default"		=> 1,
 	);	 	 
 
	
	$option[]= array( 
		"name"			=> __('Share Icon Size','reza'),
 		"id"			=> "icon_size",
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "number",
		  					

 	); 	
	$option[]= array( 
		
	
		"name"			=> esc_html__('Space Between Item','reza'),
 		"id"			=> "between",
 		"group"			=>  esc_html__('Layout','reza'),
		"type"			=> "select",
		"options" 		=> reza_array_options('between',true), 
   	); 	 	 	 	 
	$option[]= array( 
		"name"			=> __('Alignment','reza'),
 		"id"			=> "alignment",
  		"group"			=>  __('Layout','reza'),
		"default"		=>  'center',
		"desc"			=>  __('Default "Center"','reza'),
		"type"			=> "select",
			"options" 		=> reza_array_options('alignment',true), 
	
 					
		);
 

	
	$option[]= array( 
		"name"			=> __('Icon Style','reza'),
 		"id"			=> "icon_style",
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "select",
		"options"		=> array(
			"style-1" => esc_html__('Style 1: only icon','reza'),
			"style-2" => esc_html__('Style 2: Boxed Icon','reza'),
			"style-3" => esc_html__('Style 3: Boxed Original Color','reza'),
		),						
	); 
	$option[]= array( 
		"name"			=> __('Share Icon Color','reza'),
 		"id"			=> "icon_color",
		"fold"			=>  array(
			'style-1'			=>'icon_style',
			'style-2'			=>'icon_style',
 		),		
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "color_rgba",
 	); 	
	
	$option[]= array( 
		"name"			=> __('Social Icon Background','reza'),
 		"id"			=> "icon_background",
		"fold"			=>  array(
 			'style-2'			=>'icon_style',
 		),	
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "color_rgba",
 	); 	
			
	
	$option[]= array( 
		"name"			=> __('Share Icon Border Color','reza'),
 		"id"			=> "icon_border_color",
		"fold"			=>  array(
 			'style-2'			=>'icon_style',
   		),		
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "color_rgba",
 	); 	
	
	 
 	$option[]= array( 
		"name"			=> __('Share Icon Border Radius','reza'),
 		"id"			=> "icon_radius",
		"fold"			=>  array(
 			'style-2'			=>'icon_style',
 			'style-3'			=>'icon_style',
  		),	
		"group"			=>  esc_html__('Share Icon','reza'),
 		"type"			=> "select",
  		"options"		=>  reza_array_options('radius',true),						
	 
	); 	 

	   
	
	   	include REZA_PATH . '/sao-builder/general/sao-element.php';
		 
 	 
    return $option;
} 
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Share Icons Config
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_filter('sao_builder_share_icons', 'reza_share_icons_config');
function reza_share_icons_config( $args ,$out = false,$custom=false ) {
 
	$option = $args['option'];
	$key = $args['key'];
	if(reza_element_show($option)=='show'){
		$output='';
		$css ='';
		 
		
  		$share_url= !empty($option['share_url']) ?$option['share_url']:'';
		$alignment_class= !empty($option['alignment']) ?$option['alignment']:'center';
 		$between_class= !empty($option['between']) ?'rd-gap-'.$option['between']:'';
		$icon_size= !empty($option['icon_size']) ?$option['icon_size']:'';
		$style = !empty($option['icon_style']) ?$option['icon_style']:'style-1';
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';
	
		$classes = array(
			'rd-el-'.$key,
			'rd-el-share',
			 $between_class,
			empty($out)?'rd-aw':'',
			
			empty($out)?'rd-align-'.reza_alignment($alignment_class):'',
			reza_element_show($option,true),
			$custom_class		
		);
		
		ob_start(); 
		?>
	 
		<aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option);?>>
			<div class="rd-social-icon-<?php echo esc_attr($style);?>">
	 
				<?php if(!empty($option['facebook']) || (!empty($out) && empty($custom))){
					$facebook_url ="popup = window.open('http://www.facebook.com/sharer.php?u=".$share_url."&t=', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$facebook_bg =$style=='style-3'?"--rd-scl-bg:#f86811;":''; 
					?><a  onClick="<?php echo esc_html($facebook_url);?>" style="--rd-scl:'\FC01';<?php echo wp_kses_post($facebook_bg);?>"></a><?php 
				} 
				
				if(!empty($option['twitter']) || (!empty($out) && empty($custom))){
					$twitter_url ="popup = window.open('http://twitter.com/home?status= ".$share_url."', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$twitter_bg =$style=='style-3'?"--rd-scl-bg:#5da9dd;":''; 
					
					?><a onClick="<?php echo esc_html($twitter_url);?>" style="--rd-scl:'\FC03';<?php echo wp_kses_post($twitter_bg);?>"></a><?php
					
				}
				if(!empty($option['googleplus']) || (!empty($out) && empty($custom))){
					
					$googleplus_url ="popup = window.open('https://plus.google.com/share?url=".$share_url."&title=', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$googleplus_bg =$style=='style-3'?"--rd-scl-bg:#d54c40;":'';
					 
					?><a onClick="<?php echo esc_html($googleplus_url);?>" style="--rd-scl:'\FC04';<?php echo wp_kses_post($googleplus_bg);?>"></a><?php
					
				} 
							
				if(!empty($option['tumblr'])|| (!empty($out) && empty($custom))){
					$tumblr_url = "popup = window.open('http://www.tumblr.com/share/link?url=".$share_url."&name=&description=', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$tumblr_bg =$style=='style-3'?"--rd-scl-bg:#37465d;":''; 
					
					?><a onClick="<?php echo esc_html($tumblr_url);?>" style="--rd-scl:'\FC16';<?php echo wp_kses_post($tumblr_bg);?>"></a><?php
					
				} 
				if(!empty($option['linkedin'])|| (!empty($out) && empty($custom))){
					$linkedin_url ="popup = window.open('http://linkedin.com/shareArticle?mini=true&url=".$share_url."&title=', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";	
					$linkedin_bg =$style=='style-3'?"--rd-scl-bg:#0079b6;":''; 
				
					?><a onClick="<?php echo esc_html($linkedin_url);?>" style="--rd-scl:'\FC07';<?php echo wp_kses_post($linkedin_bg);?>"></a><?php
					
				} 	
	
				if(!empty($option['reddit']) || (!empty($out) && empty($custom)) ){
					$reddit_url = "popup = window.open('http://reddit.com/submit?url=http://www.google.com&title=', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$reddit_bg =$style=='style-3'?"--rd-scl-bg:#f64302;":''; 
					
					?><a onClick="<?php echo esc_html($reddit_url);?>" style="--rd-scl:'\FC29';<?php echo wp_kses_post($reddit_bg);?>"></a><?php
					
				} 
				if(!empty($option['telegram']) || (!empty($out) && empty($custom)) ){
					$telegram_url = "popup = window.open('tg://msg?text=".$share_url."', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$telegram_bg =$style=='style-3'?"--rd-scl-bg:#29a1d5;":''; 
					
					?><a onClick="<?php echo esc_html($telegram_url);?>" style="--rd-scl:'\FC05';<?php echo wp_kses_post($telegram_bg);?>"></a><?php
				} 		
		
				if(!empty($option['mail'])|| (!empty($out) && empty($custom)) ){
					$mail_url = "popup = window.open('mailto:?subject=&body=".$share_url."', 'PopupPage', 'height=450,width=500,scrollbars=yes,resizable=yes'); return false";
					$mail_bg =$style=='style-3'?"--rd-scl-bg:#2197a4;":''; 
				
					?><a onClick="<?php echo esc_html($mail_url);?>" style="--rd-scl:'\F008';<?php echo wp_kses_post($mail_bg);?>"></a><?php
				} 
				if(!empty($option['whatsapp'])|| (!empty($out) && empty($custom)) ){
					$whatsapp_url = "whatsapp://send?text=".$share_url;
					$whatsapp_url_bg =$style=='style-3'?"--rd-scl-bg:#02d300;":''; 
				
					?><a href="<?php echo esc_html($whatsapp_url);?>" data-action="share/whatsapp/share" style="--rd-scl:'\FC21';<?php echo wp_kses_post($whatsapp_url_bg);?>"></a><?php
				} 		
				?>						
				</div>
		</aside>
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css=
			reza_var_unit('--rd-scl-sz',$option,'icon_size').
			reza_var('--rd-scl-txt',$option,'icon_color').
			reza_var('--rd-scl-bg',$option,'icon_background').
			reza_var('--rd-scl-br-cr',$option,'icon_border_color').
			reza_var('--rd-scl-rd',$option,'icon_radius');
	 
			
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 