<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'sao_element_item_blog_grid_text');
function sao_element_item_blog_grid_text( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	esc_html__('نوشته های گریدی و متنی','reza'),
 		'id'			=> 'blog_grid_text',
		'group'			=> esc_html__('rabonews','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-grid-text.jpg',
  	); 
	
	return $element;
} 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_blog_grid_text', 'reza_blog_grid_text_options');
function reza_blog_grid_text_options( $option) {
 
	$element='blog';
	
	
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);		
 
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);		
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
   	$excerpt_2=true;	
   	$meta=true;	
 	$more_page_posts=true;	
	$ratio =true;	
  	$box_layout =true;
  	$image =true;
      	
   	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 

	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "grid_text_layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'grid_text_1',
 
		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"grid_text_1"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_1.jpg',
 			"grid_text_2"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_2.jpg',
 			"grid_text_3"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_3.jpg',
 			"grid_text_4"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_4.jpg',
 			"grid_text_5"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_5.jpg',
 			"grid_text_6"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_6.jpg',
 			"grid_text_7"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_7.jpg',
 			"grid_text_8"	=> get_template_directory_uri().'/admin/assets/images/grid-text/grid_text_8.jpg',
 		  
 		),						
				  
	); 
	 	
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=> reza_array_options('first_responsive_column_2',true), 

	);
 
		
 	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
  
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
   	 
 
    return $option;

}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_blog_grid_text', 'reza_builder_perview_blog_grid_text');
function reza_builder_perview_blog_grid_text( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
		if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
 			if( !empty($option['grid_text_layout'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/grid-text/'.esc_attr($option['grid_text_layout']).'.jpg">'; 
			}
		 
			 
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Config
																		
*/////////////////////////////////////// /////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_blog_grid_text', 'reza_blog_grid_text_config');
function reza_blog_grid_text_config( $args,$out=false) {
	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	if(reza_element_show($option)=='show'){
		
  		$option['post_type']='post';
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$data_key=$more_posts =="pagenavi"?' data-key="'.$key.'" ':'';
		$layout = 'grid_text';
		$option['layout'] = 'grid_text';
		$between_class =!empty($option['between'])? $option['between']:reza_option('blog_between');
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('blog_ratio');
 		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('blog_alignment');
  		
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('blog_box_layout');
 		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
	
	
	 
	
  		$layout_class =' rd-'.$box_layout;
 			
		 
		
		$classes = array(
			'rd-el-'.$key,
			'rd-ajax-tab',
			'rd-el-second',
			reza_between_border($option,$box_layout ),
 			'rd-gap-'.$between_class,
			$ratio_class,
 			'rd-align-'.reza_alignment($alignment_class),
			$layout_class,
			$custom_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
		); 
		
		ob_start(); 
		?>
		
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option).wp_kses_post($data_key);?> >
			
			
			<?php reza_post_title_tabs($option,'reza_post_'.$layout);?>
			<div class="rd-gap-content">
			<div class="rd-gap-warp">
				<div class="rd-item-list rd-flex rd-aw <?php  echo esc_attr(reza_post_class($option));?>">
				
					<?php reza_post_grid_text($option);?>
					
				</div>
				
				
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout);						
				}elseif($more_posts =="pagenavi"){
					reza_pagenavi($option);  
				}	
				?>
                
			</div> 
			</div> 
			
		</aside>  
		
		
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_caption_css($option,$item);
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 