<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.9.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
 
$key = 'product';
$between =  reza_option('product_between');
$column=reza_option('related_product_column')?reza_option('related_product_column'):'4'; 
  
$option = array(
 	'layout'=>  'grid',
  	'grid_layout'=>  'grid_'.$column,
	'box_layout' => reza_option('product_box_layout'),
 	'post_title' => 1,
  	'title_limit' => reza_option('product_title_limit'),
	'excerpt' =>  0,
	'excerpt_limit' => 0,
 	'thumb' => reza_option('product_thumb'), 
 	'rating'  => reza_option('product_meta_rating'),
 	'addcart'  => reza_option('product_addcart',true),

 	'image_size'=>  reza_option('product_image_size'),
	'image_width'=>  reza_option('product_image_width'),
	'image_alignment'=>  reza_option('product_image_alignment' ),
	'second_image'=>  reza_option('product_second_image',true),
  	'alignment'=> reza_option('product_alignment'),
 	'meta_category'  => reza_option('product_meta_category',true),
   	
  ); 
  
$between_class =reza_option('product_between');
$ratio_class =reza_option('product_ratio');
$alignment_class =reza_option('product_alignment');
$second_image_class =reza_option('product_second_image')?'rd-has-second':'';
$box_layout =reza_option('product_box_layout');
$box_layout_class = 'rd-'.$box_layout;
	
 
$classes = array(
  	'rd-el-product',
	'rd-gap-'.$between_class,
	$ratio_class,
	$second_image_class,
	'rd-align-'.reza_alignment($alignment_class),
	$box_layout_class,
);
	
	
if ( $related_products ) :	?>

<section class="<?php echo esc_attr(join( ' ', $classes ));?>" >
	 
	<?php $title_class= reza_option('title_box_style');?>
    
	 <div class="rd-tbox-<?php echo esc_attr($title_class);?>">		
 		<h4 class="rd-title-box"><div class="rd-tab-main"><span><?php echo reza_t( 'relatedproducts' );?></span></div></h4>
	</div>
	<div class="rd-gap-content">
	<div class="rd-gap-warp" >
		<div class="rd-item-list rd-aw rd-flex <?php echo reza_post_class($option);?> products"  >

 			<?php foreach ( $related_products as $related_product ) :  ?>
 				 
				<?php $post_object = get_post( $related_product->get_id() );?>
 				<?php setup_postdata( $GLOBALS['post'] =& $post_object );?>
				<?php reza_product_module_2($option);?>
 
			<?php endforeach; ?>
		
        </div>
	
    </div>
    </div>
 
</section>
<?php
endif;

wp_reset_postdata();
